#!/usr/bin/env python

"""
Convert bween multiline fasta and single line
"""

from Bio import SeqIO
import sys

filename = sys.argv[1]
output = sys.argv[2]



records = list(SeqIO.parse(filename,'fasta'))


with open(output,'w') as out_fp:
	for record in records:
		out_fp.write(">"+record.id+"\n")
		out_fp.write(str(record.seq))
		out_fp.write("\n")
